
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

// BEGINFILE AskButtonArea.js -------------------------------------------------------------------------->

AskButtonArea.prototype = new AreaBase();
function AskButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	this.PrimarySpeakerEmail = "";
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "AskButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		
		this.HandleButtonState();
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		this.ScriptEventHandler = new SfEventHandler("AskButtonArea");
		this.ScriptEventHandler.MethodName = "OnScriptEvent";
		this.ScriptEventHandler.Container = this.Container;
		
		MainHelper.EventScript.AddHandler(this.ScriptEventHandler);

		this.DataAvailableEventHandler = new SfEventHandler("AskButtonArea");
		this.DataAvailableEventHandler.MethodName = "OnDataAvailableEvent";
		this.DataAvailableEventHandler.Container = this.Container;
		
		MainHelper.EventDataAvailable.AddHandler(this.DataAvailableEventHandler);
	}

	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		MainHelper.EventScript.RemoveHandler(this.ScriptEventHandler);
		MainHelper.EventDataAvailable.RemoveHandler(this.DataAvailableEventHandler);
	}
	
	this.OnScriptEvent = function(args)
	{
		this.Debug("OnScriptEvent called");
		switch(args.Command)
		{
			case SfScriptCommandType.EndPresentation:
				this.button.Enable(false);
				break;
		}
	}
	
	this.OnDataAvailableEvent = function(args)
	{
		this.Debug("DataAvailableEvent called");
		this.HandleButtonState();
	}

	this.HandleButtonState = function()
	{
		if (MainHelper.Presentation.IsStandAlone == true)
		{
			// in standalone these are always disabled
			this.button.Enable(false);
			return;
		}

		// live or replay
		if ( (MainHelper.Presentation.ForumEnabled == true) && ((MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress) || (this.PrimarySpeakerEmail != "")))
		{
			this.button.Enable(true);
		}
		else
		{
			this.button.Enable(false);
		}
			
	}
	
	this.OnClick = function()
	{
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			// needs to be resizeable
			window.popupAsk = WindowHelper.CreateNamedPopup(PopupNames.Forum, "polls", 450, 305, true, false);
			if (window.popupAsk) 
			{
				window.popupAsk.focus();
			}
		}
		else if ( this.PrimarySpeakerEmail != "" )
		{
			window.location = "mailto:" + this.PrimarySpeakerEmail;
		}
	}
}


// ENDFILE AskButtonArea.js ---------------------------------------------------------------------------->

// BEGINFILE ButtonGroupArea.js ------------------------------------------------------------------------>

function ButtonGroupArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "ButtonGroupArea: " + msg);
	}
		
	this.Initialize = function(container, containingWindow, ID)
	{
		this.Debug("Initialize called");
		this.Container = container;
		this.ContaingWindow = containingWindow;
		this.ID = ID;
		SfOnLoad.AddHandler("" + this.Container + ".OnLoad()");
	}

	this.Initialize(container, containingWindow, ID);
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad called");
		var len = this.Buttons.length;
		
		var i;
		for (i=0; i<len; ++i)
		{
			this.Buttons[i].button.ClickHandler = new Function("", 
				this.Container + ".OnClick('" + this.Buttons[i].Container + "');");
		}
	}
	
	this.OnClick = function(buttonContainer)
	{
		this.Debug("OnClick called");
		this.Debug("container: " + buttonContainer);

		var len = this.Buttons.length;
		var i;
		for (i=0; i<len; ++i)
		{
			if (this.Buttons[i].Container == buttonContainer)
			{
				this.Buttons[i].OnClick();
			}
			else
			{
				this.Buttons[i].button.SetCheck(false);
			}
		}
	}
}

// ENDFILE ButtonGroupArea.js -------------------------------------------------------------------------->

// BEGINFILE CloseButtonArea.js ------------------------------------------------------------------------>

CloseButtonArea.prototype = new AreaBase();
function CloseButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "CloseButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		top.close();
	}
}

// ENDFILE CloseButtonArea.js -------------------------------------------------------------------------->

// BEGINFILE FullScreenButtonArea.js ------------------------------------------------------------------->

FullScreenButtonArea.prototype = new AreaBase();
function FullScreenButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "FullScreenButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.EnableDisableButton = function()
	{
		this.Debug("EnableDisableButton called");
		if (MainHelper.Presentation.IsAudioOnly == true)
		{
			this.Debug("IsAudioOnly");
			this.button.Enable(false);
		}
		else
		{
			this.Debug("Not IsAudioOnly");
			this.button.Enable(true);
		}
	}
	
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("FullScreenButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		this.EnableDisableButton();
	}
	
	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.FullScreen));
	}
	
}

// ENDFILE FullScreenButtonArea.js --------------------------------------------------------------------->

// BEGINFILE HelpButtonArea.js ------------------------------------------------------------------------->

HelpButtonArea.prototype = new AreaBase();
function HelpButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "HelpButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		WindowHelper.PopupHelp(GetPopupURL(PopupNames.Help),450,330);
	}
}

// ENDFILE HelpButtonArea.js --------------------------------------------------------------------------->

// BEGINFILE InfoButtonArea.js ------------------------------------------------------------------------->

InfoButtonArea.prototype = new AreaBase();
function InfoButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "InfoButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		
		this.button.Initialize();
		
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick");
		
		if (this.button.IsChecked == true)
		{
			return;
		}
		
		this.button.SetCheck(true);
	
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ShowInfo));
	}
	
}

// ENDFILE InfoButtonArea.js --------------------------------------------------------------------------->

// BEGINFILE MaxSlideButtonArea.js --------------------------------------------------------------------->

MaxSlideButtonArea.prototype = new AreaBase();
function MaxSlideButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "MaxSlideButtonArea: " + msg);
	}
	
	this.RegisterEvents = function()
	{
		this.Debug("RegisterEvents called");
		this.ScriptEventHandler = new SfEventHandler(this.Container);
		this.ScriptEventHandler.Container = this.Container;
		this.ScriptEventHandler.MethodName = "OnScriptEvent";
		MainHelper.EventScript.AddHandler(this.ScriptEventHandler);
	}
	
	this.UnRegisterEvents = function()
	{
		this.Debug("UnRegisterEvents called");
		MainHelper.EventScript.RemoveHandler(this.ScriptEventHandler);
	}

	this.OnScriptEvent = function(args)
	{
		this.Debug("OnScriptEvent: " + args);
		switch(args.Command)
		{
			case SfScriptCommandType.EndPresentation:
				this.button.Enable(false);
				break;
			case SfScriptCommandType.ShowSlide:
				if (args.Index > 0)
				{
					this.button.Enable(true);
				}
				else
				{
					this.button.Enable(false);
				}
				break;
		}
	}

	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		if (this.ShouldEnableButtonInBeginning() == true)
		{
			this.button.IsEnabled = true;
		}
		else
		{
			this.button.IsEnabled = false;
		}
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		this.RegisterEvents();
	}
	
	this.ShouldEnableButtonInBeginning = function()
	{
		this.Debug("ShouldEnableButtonInBeginning");
		if (MainHelper.Presentation.Status != PresentationStatus.CaptureInProgress)
		{
			// disable all non-live presentations
			return false;
		}
		
		// it is a live presentation
		if (MainHelper.MaxSlideTimings > 0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.UnRegisterEvents();
	}

	// need to duplicate the functionality in CurrentSlideArea
	// because of Google popup blocker issue	
	this.OnClick = function()
	{
		this.Debug("OnClick");
		
		if (WindowHelper.IsOpen(MainHelper.PopupWindows.FullSize) == true)
		{
			this.Debug("Is already open");
			return;
		}
		
		MainHelper.PopupWindows.FullSize =
			
			WindowHelper.CreateNamedPopup(
				PopupNames.FullSize,
				"FullSize",
				MainHelper.DefaultFullSizeWindowWidth,
				MainHelper.DefaultFullSizeWindowHeight,
				true,
				true);
	}
}

// ENDFILE MaxSlideButtonArea.js ----------------------------------------------------------------------->

// BEGINFILE MuteButtonArea.js ------------------------------------------------------------------------->

MuteButtonArea.prototype = new AreaBase();
function MuteButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "MuteButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("MuteButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
		
 		this.VolumeChangedEventHandler = new SfEventHandler("MuteButtonArea");
		this.VolumeChangedEventHandler.MethodName = "OnVolumeChangedEvent";
		this.VolumeChangedEventHandler.Container = this.Container;
		MainHelper.EventVolumeChanged.AddHandler(this.VolumeChangedEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
		MainHelper.EventVolumeChanged.RemoveHandler(this.VolumeChangedEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		this.button.Enable(true);
	}
	
	this.OnVolumeChangedEvent = function(args)
	{
		this.Debug("OnVolumeChangedEvent: " + args);
		switch(args.ChangeType)
		{
			case SfVolumeChangeType.Muted:
				this.button.SetCheck(true);
				this.button.SetToolTip("Mute Off");
				break;
			case SfVolumeChangeType.UnMuted:
				this.button.SetCheck(false);
				this.button.SetToolTip("Mute");
				break;
		}
	}

	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ToggleMute));
	}
	
}

// ENDFILE MuteButtonArea.js --------------------------------------------------------------------------->

// BEGINFILE NextSlideButtonArea.js -------------------------------------------------------------------->

NextSlideButtonArea.prototype = new AreaBase();
function NextSlideButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "NextSlideButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		
		this.button.Initialize();
		
		this.AddEventHandlers();
		
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		this.HandleButtonState(-1);
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.SlideChangedEventHandler = new SfEventHandler("NextSlideButtonArea");
		this.SlideChangedEventHandler.MethodName = "OnSlideChangedEvent";
		this.SlideChangedEventHandler.Container = this.Container;
		MainHelper.EventSlideChanged.AddHandler(this.SlideChangedEventHandler);
		
		this.CommandEventHandler = new SfEventHandler("NextSlideButtonArea");
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		this.CommandEventHandler.Container = this.Container;
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);

		this.PlayBeginEventHandler = new SfEventHandler("NextSlideButtonArea");
		this.PlayBeginEventHandler.MethodName = "OnPlayBeginEvent";
		this.PlayBeginEventHandler.Container = this.Container;
		MainHelper.EventPlayBegin.AddHandler(this.PlayBeginEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventSlideChanged.RemoveHandler(this.SlideChangedEventHandler);
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		MainHelper.EventPlayBegin.RemoveHandler(this.PlayBeginEventHandler);
	}

	this.OnSlideChangedEvent = function(args)
	{
		this.Debug("OnSlideChanged called, :" + args.Index);
		var index = args.Index;
		this.HandleButtonState(Number(index));
	}
	
	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.Show();
				break;
			case SfCommandType.ShowSlideList:
				this.Hide();
				break;
		}
	}

	this.OnPlayBeginEvent = function(args)
	{
		this.Debug("OnPlayBeginEvent");
		this.HandleButtonState(-1);
	}

	this.OnClick = function()
	{
		this.Debug("NextSlideHandler called");
		var currentSlide = MainHelper.CurrentSlideNumber;
		var maxSlide = MainHelper.MaxSlideTimings;
		this.Debug("CurrentSlide: " + currentSlide + ", maxSlide: " + maxSlide);
		if (currentSlide == -1 && maxSlide > 0)
		{
			var args = new CommandArgs(SfCommandType.NavigateToSlide);
			args.SlideNumber = 1;
			MainHelper.EventCommand.Post(args);
		}
		else if (currentSlide < maxSlide)
		{
			var args = new CommandArgs(SfCommandType.NavigateToSlide);
			args.SlideNumber = currentSlide + 1;
			MainHelper.EventCommand.Post(args);
		}
		else
		{
			SfDebug.DPF(SfDebug.ErrMsgSubCritical, "Next slide should not be called here");
			return;
		}

		this.TimedDisable(1000);
	}
	
	this.InTimeDisabled = false;
	this.EnableLater = false;
	this.TimedDisable = function(milliSeconds)
	{
		this.Debug("TimedDisable called: " + milliSeconds);
		
		this.InTimeDisabled = true;
		this.button.Enable(false);

		setTimeout(this.Container + '.TimedEnable()', milliSeconds);
	}
	
	this.TimedEnable = function()
	{
		this.Debug("TimedEnable called");
		
		if (this.EnableLater == true)
		{
			this.Debug("Enabling Next button");
			this.button.Enable(true);
		}
		else
		{
			this.Debug("Disabling Next button");
			this.button.Enable(false);
		}
		
		this.InTimeDisabled = false;
	}

	this.HandleButtonState = function(currentSlide)
	{
		this.Debug("HandleButtonState called, CurrentSlide: " + currentSlide);
		this.EnableLater = false;
		
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			// disable in live mode
			this.button.Enable(false);
			return;
		}
		
		var maxSlide = MainHelper.MaxSlideTimings;
		this.Debug("MaxSlide: " + maxSlide);
		if (currentSlide == -1)
		{
			// uninitialized
			if (maxSlide > 0)
			{
				this.button.Enable(true);
			}
			else
			{
				this.button.Enable(false);
			}
			return;
		}
		
		if (currentSlide < maxSlide)
		{
			if (this.InTimeDisabled == true)
			{
				this.EnableLater = true;
			}
			else
			{
				this.button.Enable(true);
			}
		}
		else
		{
			this.button.Enable(false);
		}
	}
	
}

// ENDFILE NextSlideButtonArea.js ---------------------------------------------------------------------->

// BEGINFILE OptionsButtonArea.js ---------------------------------------------------------------------->

OptionsButtonArea.prototype = new AreaBase();
function OptionsButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "OptionsButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		
		this.HandleButtonState();
	}
	
	this.HandleButtonState = function()
	{
		if (MainHelper.Presentation.IsStandAlone == true)
		{
			// in standalone these are always disabled
			this.button.Enable(false);
		}
		else
		{
			// live or replay
			this.button.Enable(true);
		}		
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		// needs to be resizeable
		window.popupoptions = WindowHelper.CreateNamedPopup(PopupNames.Options,"__options",400,200,false,false);
		if (window.popupoptions) 
		{
			window.popupoptions.focus();
		}
	}
}

// ENDFILE OptionsButtonArea.js ------------------------------------------------------------------------>

// BEGINFILE PauseButtonArea.js ------------------------------------------------------------------------>

PauseButtonArea.prototype = new AreaBase();
function PauseButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "PauseButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("PauseButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
		
		this.PlayerStateChangedEventHandler = new SfEventHandler("PauseButtonArea");
		this.PlayerStateChangedEventHandler.MethodName = "OnPlayerStateChangedEvent";
		this.PlayerStateChangedEventHandler.Container = this.Container;
		MainHelper.EventPlayerStateChanged.AddHandler(this.PlayerStateChangedEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
		MainHelper.EventPlayerStateChanged.RemoveHandler(this.PlayerStateChangedEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			this.button.Enable(false);
		}
		else
		{
			this.button.Enable(true);
		}
	}
	
	this.OnPlayerStateChangedEvent = function(state)
	{
		this.Debug("OnPlayerStateChangedEvent: " + state);
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			if (this.button.IsEnabled == true)
			{
				this.button.Enable(false);
			}
			return;
		}

		var pauseIsEnabled = true;
		switch(state)
		{
			case PlayState.Stopped:
			case PlayState.Ready:
			case PlayState.Paused:
				pauseIsEnabled = false;
				break;
			case PlayState.Playing:
				pauseIsEnabled = true;
				break;
			default:
				return;
		}
		
		this.Debug("ButtonEnabledState: " + pauseIsEnabled);
		if (pauseIsEnabled)
		{
			if (this.button.IsEnabled == false)
			{
				this.button.Enable(true);
			}
		}
		else
		{
			if (this.button.IsEnabled == true)
			{
				this.button.Enable(false);
			}
		}
	}

	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.Pause));
	}
	
}

// ENDFILE PauseButtonArea.js -------------------------------------------------------------------------->

// BEGINFILE PlayButtonArea.js ------------------------------------------------------------------------->

PlayButtonArea.prototype = new AreaBase();
function PlayButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "PlayButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("PlayButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
		
		this.PlayerStateChangedEventHandler = new SfEventHandler("PlayButtonArea");
		this.PlayerStateChangedEventHandler.MethodName = "OnPlayerStateChangedEvent";
		this.PlayerStateChangedEventHandler.Container = this.Container;
		MainHelper.EventPlayerStateChanged.AddHandler(this.PlayerStateChangedEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
		MainHelper.EventPlayerStateChanged.RemoveHandler(this.PlayerStateChangedEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		this.button.Enable(true);
	}
	
	this.OnPlayerStateChangedEvent = function(state)
	{
		this.Debug("OnPlayerStateChangedEvent: " + state);
		var playIsEnabled = true;
		
		switch(state)
		{
			case PlayState.Stopped:
			case PlayState.Ready:
			case PlayState.Paused:
				playIsEnabled = true;
				break;
			case PlayState.Playing:
				playIsEnabled=false;
				break;
			default:
				return;
		}
		
		this.Debug("ButtonEnabledState: " + playIsEnabled);
		if (playIsEnabled)
		{
			if (this.button.IsEnabled == false)
			{
				this.button.Enable(true);
			}
		}
		else
		{
			if (this.button.IsEnabled == true)
			{
				this.button.Enable(false);
			}
		}
	}

	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.Play));
	}
	
}

// ENDFILE PlayButtonArea.js --------------------------------------------------------------------------->

// BEGINFILE PollButtonArea.js ------------------------------------------------------------------------->

PollButtonArea.prototype = new AreaBase();
function PollButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "PollButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		
		this.HandleButtonState();
	}
	
	this.HandleButtonState = function()
	{
		this.Debug("HandleButtonState called");

		// in standalone these are always disabled
		if (MainHelper.Presentation.IsStandAlone == true)
		{
			this.Debug("disabling for standalone");
			this.button.Enable(false);
			return;
		}
		
		if ( (MainHelper.Presentation.PollsEnabled == false) && (MainHelper.Presentation.PollResultsEnabled == false) )
		{
			this.Debug("no polls are present");
			this.button.Enable(false);
		}
		else
		{
			this.Debug("polls present");
			this.button.Enable(true);
		}
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick called");
		// needs to be resizeable
		window.popupPoll = WindowHelper.CreateNamedPopup(PopupNames.ShowPolls, "polls", 600, 450, true, false);
		if (window.popupPoll) 
		{
			window.popupPoll.focus();
		}
	}
}

// ENDFILE PollButtonArea.js --------------------------------------------------------------------------->

// BEGINFILE PresentationDetailsButtonArea.js ---------------------------------------------------------->

PresentationDetailsButtonArea.prototype = new AreaBase();
function PresentationDetailsButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "PresentationDetailsButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		this.button.Enable(true);
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		window.popupDetails = WindowHelper.CreateNamedPopup(PopupNames.PresentationDetails, "pd", 650, 300, true, false);
		window.popupDetails.focus();
	}
}

// ENDFILE PresentationDetailsButtonArea.js ------------------------------------------------------------>

// BEGINFILE PreviousSlideButtonArea.js ---------------------------------------------------------------->

PreviousSlideButtonArea.prototype = new AreaBase();
function PreviousSlideButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "PreviousSlideButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		
		this.button.Initialize();
		
		this.AddEventHandlers();
		
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
		this.HandleButtonState(-1);
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.SlideChangedEventHandler = new SfEventHandler("PreviousSlideButtonArea");
		this.SlideChangedEventHandler.MethodName = "OnSlideChangedEvent";
		this.SlideChangedEventHandler.Container = this.Container;
		MainHelper.EventSlideChanged.AddHandler(this.SlideChangedEventHandler);

		this.CommandEventHandler = new SfEventHandler("PreviousSlideButtonArea");
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		this.CommandEventHandler.Container = this.Container;
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
		
		this.PlayBeginEventHandler = new SfEventHandler("PreviousSlideButtonArea");
		this.PlayBeginEventHandler.MethodName = "OnPlayBeginEvent";
		this.PlayBeginEventHandler.Container = this.Container;
		MainHelper.EventPlayBegin.AddHandler(this.PlayBeginEventHandler);
		
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventSlideChanged.RemoveHandler(this.SlideChangedEventHandler);
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		MainHelper.EventPlayBegin.RemoveHandler(this.PlayBeginEventHandler);
	}

	this.OnSlideChangedEvent = function(args)
	{
		this.Debug("OnSlideChanged called, :" + args.Index);
		var index = args.Index;
		this.HandleButtonState(Number(index));
	}
	
	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.Show();
				break;
			case SfCommandType.ShowSlideList:
				this.Hide();
				break;
		}
	}

	this.OnPlayBeginEvent = function(args)
	{
		this.Debug("OnPlayBeginEvent");
		this.HandleButtonState(-1);
	}

	this.OnClick = function()
	{
		this.Debug("Previous SlideHandler called");
		
		var currentSlide = MainHelper.CurrentSlideNumber;
		this.Debug("OnClick CurrentSlide: " + currentSlide);
		
		var toJumpTo;
		if (MainHelper.PresentationEnded == true && currentSlide == MainHelper.MaxSlideTimings)
		{
			toJumpTo = currentSlide;
		}
		else if (currentSlide > 1)
		{
			toJumpTo = currentSlide-1;
		}
		else
		{
			SfDebug.DPF(SfDebug.ErrMsgSubCritical, "PreviousSlide should not be called here");
			return;
		}

		var args = new CommandArgs(SfCommandType.NavigateToSlide);
		args.SlideNumber = (toJumpTo);
		MainHelper.EventCommand.Post(args);
		
		this.TimedDisable(1000);
	}
	
	this.InTimeDisabled = false;
	this.EnableLater = false;
	this.TimedDisable = function(milliSeconds)
	{
		this.Debug("TimedDisable called for: " + milliSeconds);
		
		this.InTimeDisabled = true;
		this.button.Enable(false);

		setTimeout(this.Container + '.TimedEnable()', milliSeconds);
	}
	
	this.TimedEnable = function()
	{
		this.Debug("TimedEnable called");
		if (this.EnableLater == true)
		{
			this.Debug("Enabling Previous button");
			this.button.Enable(true);
		}
		else
		{
			this.Debug("Disabling Previous button");
			this.button.Enable(false);
		}
		
		this.InTimeDisabled = false;
	}

	this.HandleButtonState = function(currentSlide)
	{
		this.Debug("HandleButtonState called, CurrentSlide: " + currentSlide);
		this.EnableLater = false;
		
		if (MainHelper.Presentation.Status == PresentationStatus.CaptureInProgress)
		{
			// disable in live mode
			this.button.Enable(false);
			return;
		}
		
		if (currentSlide < 2)
		{
			// uninitialized, or slide number 1
			this.button.Enable(false);
			return;
		}
		
		if (this.InTimeDisabled == true)
		{
			this.EnableLater = true;
		}
		else
		{
			this.button.Enable(true);
		}
	}
	
}

// ENDFILE PreviousSlideButtonArea.js ------------------------------------------------------------------>

// BEGINFILE SlideListButtonArea.js -------------------------------------------------------------------->

SlideListButtonArea.prototype = new AreaBase();
function SlideListButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "SlideListButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		
		this.InitializeButtonState();
				
		this.AddEventHandlers();
		
	}
	
	this.InitializeButtonState = function()
	{
		this.Debug("InitializeButtonState called");
		
		if (MainHelper.MaxSlideTimings < 1)
		{
			this.Debug("No slides so disabling");
			this.button.IsEnabled = false;
		}
		this.button.Initialize();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.CommandEventHandler = new SfEventHandler("SlideListButtonArea");
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		this.CommandEventHandler.Container = this.Container;
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
		
		this.SlideChangedEventHandler = new SfEventHandler(this.Container);
		this.SlideChangedEventHandler.Container = this.Container;
		this.SlideChangedEventHandler.MethodName = "OnSlideChangedEvent";
		MainHelper.EventSlideChanged.AddHandler(this.SlideChangedEventHandler);	
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
		MainHelper.EventSlideChanged.RemoveHandler(this.SlideChangedEventHandler);
	}

	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.button.SetCheck(false);
				break;
			case SfCommandType.ShowSlideList:
				this.button.SetCheck(true);
				break;
		}
	}
	
	this.OnSlideChangedEvent = function(args)
	{
		this.Debug("OnSlideChangedEvent: " + args);
		if (this.button.IsEnabled == false)
		{
			this.button.Enable(true);
		}
	}

	this.OnClick = function()
	{
		this.Debug("OnClick");
		
		if (this.button.IsChecked == true)
		{
			return;
		}
		
		this.button.SetCheck(true);
	
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ShowSlideList));
		
		var slide = SfDOM.FindElementFromID(document, "lblSlide");
		if (slide)
		{
			slide.style.visibility = 'hidden';
		}
	}
	
}

// ENDFILE SlideListButtonArea.js ---------------------------------------------------------------------->

// BEGINFILE SlideShowButtonArea.js -------------------------------------------------------------------->

SlideShowButtonArea.prototype = new AreaBase();
function SlideShowButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "SlideShowButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		
		this.button.Initialize();
		
		this.AddEventHandlers();
		
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.CommandEventHandler = new SfEventHandler("SlideShowButtonArea");
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		this.CommandEventHandler.Container = this.Container;
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandlers");
		
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
	}

	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideList:
				this.button.SetCheck(false);
				break;
			case SfCommandType.ShowSlideShow:
				this.button.SetCheck(true);
				break;
		}
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick");
		
		if (this.button.IsChecked == true)
		{
			return;
		}
		
		this.button.SetCheck(true);
	
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ShowSlideShow));
	
		var slide = SfDOM.FindElementFromID(document, "lblSlide");
		if (slide)
		{
			slide.style.visibility = 'visible';
		}
	}
	
}

// ENDFILE SlideShowButtonArea.js ---------------------------------------------------------------------->

// BEGINFILE StopButtonArea.js ------------------------------------------------------------------------->

StopButtonArea.prototype = new AreaBase();
function StopButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "StopButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("StopButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
		
		this.PlayerStateChangedEventHandler = new SfEventHandler("StopButtonArea");
		this.PlayerStateChangedEventHandler.MethodName = "OnPlayerStateChangedEvent";
		this.PlayerStateChangedEventHandler.Container = this.Container;
		MainHelper.EventPlayerStateChanged.AddHandler(this.PlayerStateChangedEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
		MainHelper.EventPlayerStateChanged.RemoveHandler(this.PlayerStateChangedEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		this.button.Enable(true);
	}
	
	this.OnPlayerStateChangedEvent = function(state)
	{
		this.Debug("OnPlayerStateChangedEvent: " + state);
		var stopIsEnabled = true;

		switch(state)
		{
			case PlayState.Paused:
			case PlayState.Stopped:
			case PlayState.Ready:
				stopIsEnabled = false;
				break;
			case PlayState.Playing:
				stopIsEnabled = true;
				break;
			default:
				return;
		}
	
		this.Debug("ButtonEnabledState: " + stopIsEnabled);
		if (stopIsEnabled)
		{
			if (this.button.IsEnabled == false)
			{
				this.button.Enable(true);
			}
		}
		else
		{
			if (this.button.IsEnabled == true)
			{
				this.button.Enable(false);
			}
		}
	}

	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.Stop));
	}
	
}

// ENDFILE StopButtonArea.js --------------------------------------------------------------------------->

// BEGINFILE TextSlideListButtonArea.js ---------------------------------------------------------------->

TextSlideListButtonArea.prototype = new AreaBase();
function TextSlideListButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "TextSlideListButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		
		this.button.Initialize();
		
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick");
		
		if (this.button.IsChecked == true)
		{
			return;
		}
		
		this.button.SetCheck(true);
	
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ShowTextSlideList));
	}
	
}

// ENDFILE TextSlideListButtonArea.js ------------------------------------------------------------------>

// BEGINFILE VolumeDownButtonArea.js ------------------------------------------------------------------->

VolumeDownButtonArea.prototype = new AreaBase();
function VolumeDownButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "VolumeDownButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("VolumeDownButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		this.button.Enable(true);
	}
	
	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.VolumeDown));
	}
	
}

// ENDFILE VolumeDownButtonArea.js --------------------------------------------------------------------->

// BEGINFILE VolumeUpButtonArea.js --------------------------------------------------------------------->

VolumeUpButtonArea.prototype = new AreaBase();
function VolumeUpButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "VolumeUpButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		this.button.Initialize();
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");
		
		this.PlayerSetupCompleteEventHandler = new SfEventHandler("VolumeUpButtonArea");
		this.PlayerSetupCompleteEventHandler.MethodName = "OnPlayerSetupCompleteEvent";
		this.PlayerSetupCompleteEventHandler.Container = this.Container;
		MainHelper.EventPlayerSetupComplete.AddHandler(this.PlayerSetupCompleteEventHandler);
	}
	
	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandler");
		
		MainHelper.EventPlayerSetupComplete.RemoveHandler(this.PlayerSetupCompleteEventHandler);
	}

	this.OnPlayerSetupCompleteEvent = function(args)
	{
		this.Debug("OnPlayerSetupCompleteEvent called");
		this.button.Enable(true);
	}
	
	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.VolumeUp));
	}
	
}

// ENDFILE VolumeUpButtonArea.js ----------------------------------------------------------------------->

// BEGINFILE ShowSlideDescriptionButtonArea.js ------------------------------------------------------------------------->

ShowSlideDescriptionButtonArea.prototype = new AreaBase();
function ShowSlideDescriptionButtonArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;
	this.DidIMute = false;
	
	this.InitializeArea(container, containingWindow, ID);
	
	this.Debug = function(msg)
	{
		SfDebug.DPF(this.m_debugLevel, "ShowSlideDescriptionButtonArea: " + msg);
	}
	
	this.OnLoad = function()
	{
		this.Debug("OnLoad");
		if (this.Enabled == false || MainHelper.Presentation.Status != PresentationStatus.ReplayReady)
		{
			this.Hide();
			return;
		}
		this.button.Initialize();
		this.button.SetToolTip(this.ShowSlideDescriptionToolTip);
		this.AddEventHandlers();
		this.button.ClickHandler = new Function("", this.Container + ".OnClick();");
	}
	
	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad");
		if (this.Enabled == false || MainHelper.Presentation.Status != PresentationStatus.ReplayReady)
		{
			return;
		}
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers");

		this.CommandEventHandler = new SfEventHandler("ShowSlideDescriptionButtonArea");
		this.CommandEventHandler.MethodName = "OnCommandEvent";
		this.CommandEventHandler.Container = this.Container;
		MainHelper.EventCommand.AddHandler(this.CommandEventHandler);

	}
	
	this.RemoveEventHandlers = function()
	{  
		this.Debug("RemoveEventHandler");
		  
		MainHelper.EventCommand.RemoveHandler(this.CommandEventHandler);
	}

	this.OnClick = function()
	{
		MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.ShowSlideDescription));
		this.button.SetCheck(!this.button.IsChecked);
		
		if (this.button.IsChecked == true)
		{
			this.button.SetToolTip(this.ShowSlideImageToolTip);
			MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.Pause));
		}
		else
		{
			this.button.SetToolTip(this.ShowSlideDescriptionToolTip);
			if (MainHelper.PresentationEnded == false)
			{
				MainHelper.EventCommand.Post(new CommandArgs(SfCommandType.Play));
			}
		}
	}
	
	this.OnCommandEvent = function(args)
	{
		this.Debug("OnCommandEvent: " + args);
		switch(args.Command)
		{
			case SfCommandType.ShowSlideShow:
				this.Show();
				break;
			case SfCommandType.ShowSlideList:
				this.Hide();
				break;
			case SfCommandType.Play:
				this.button.SetCheck(false);
				this.button.SetToolTip(this.ShowSlideDescriptionToolTip);
				break;
				
		}
	}
}

// ENDFILE ShowSlideDescriptionButtonArea.js --------------------------------------------------------------------------->
